function [batt, cap] = battModel(veh, em, battSOC, capSOC)

% Electrical load power
loadPwr = em.elPwr; % May add electrical accesories power here
loadPwr = (loadPwr>0)  .* loadPwr ./ veh.batt.inverterEff...
    + (loadPwr<=0) .* loadPwr .* veh.batt.inverterEff;


% Battery internal resistance
battRes = veh.batt.eqRes(battSOC);
% Battery voltage
batt.ocv = veh.batt.ocv(battSOC);

if isfield(veh, 'cap')
    % Supercap internal resistance
    capRes = veh.cap.eqRes;
    % Supercap voltage
    cap.ocv = capSOC .* veh.cap.nomVolt;

    if loadPwr ~= 0
        % Load current not 0 -> inverter DC side gets treated as a current generator
        % Equivalent circuit for Battery-Supercap system in direct parallel
        % connection
        eqRes = (capRes .* battRes)./(capRes + battRes);
        eqVolt = (batt.ocv.*capRes + cap.ocv.*battRes) ./ (capRes + battRes);

        % Load (inverter DC-side) voltage and current
        loadCurr = ( 2 .* loadPwr ) ./ ( eqVolt + sqrt(eqVolt.^2 - 4.*eqRes.*loadPwr) );
        loadVolt = loadPwr ./ loadCurr;

        % Supercap & battery current
        batt.curr = (batt.ocv - loadVolt) ./ battRes;
        cap.curr = (cap.ocv - loadVolt) ./ capRes;

    else
        % Load current = 0 -> inverter DC side gets treated as an open circuit
        batt.curr = (batt.ocv - cap.ocv) ./ (capRes + battRes);
        cap.curr = - batt.curr;
    end

    % Update supercap state of charge
    cap.SOC = - cap.curr ./ (veh.cap.nomVolt .* veh.cap.capacitance) .* veh.dt + capSOC;

    cap.pwr = cap.curr.*cap.ocv;
    batt.pwr = batt.curr.*batt.ocv;
else
    cap = [];
    % Battery current
    batt.pwr = loadPwr;
    batt.curr = ( 2 .* batt.pwr ) ./ ( batt.ocv + sqrt(batt.ocv.^2 - 4.*battRes.*batt.pwr) );
    batt.curr = real(batt.curr);
end

% Update battery state of charge
batt.SOC  = - veh.batt.coulombicEff .* batt.curr ./ (veh.batt.nomCap * 3600) .* veh.dt + battSOC;

    
    

% Constraints
% Maximum charge current
maxCurr_ptt = ( batt.ocv ) ./ ( 4.* battRes ); % Maximum power transfer theorem
maxChrgBattCurr = max( veh.batt.minCurr, - maxCurr_ptt );
% Maximum discharge current
maxDisBattCurr = veh.batt.maxDisCurr;
batt.unfeas = (batt.curr<=0).*(batt.curr < maxChrgBattCurr) + (batt.curr>0).*(batt.curr > maxDisBattCurr);
